/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;

final class DataViewBuilders {
    DataViewBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JComboBox.class.getName())) {
            return new JComboBoxBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JList.class.getName())) {
            return new JListBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTree.class.getName())) {
            return new JTreeBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTable.class.getName())) {
            return new JTableBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTableHeader.class.getName())) {
            return new JTableHeaderBuilder(instance, heap);
        }
        return null;
    }

    private static class JTableHeaderBuilder
    extends ComponentBuilders.JComponentBuilder<JTableHeader> {
        private final TableColumnModelBuilder columnModel;

        JTableHeaderBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.columnModel = TableColumnModelBuilder.fromField(instance, "columnModel", heap);
        }

        @Override
        protected void setupInstance(JTableHeader jTableHeader) {
            DefaultTableColumnModel defaultTableColumnModel;
            super.setupInstance(jTableHeader);
            DefaultTableColumnModel defaultTableColumnModel2 = defaultTableColumnModel = this.columnModel == null ? null : (DefaultTableColumnModel)this.columnModel.createInstance();
            if (defaultTableColumnModel == null || defaultTableColumnModel.getColumnCount() == 0) {
                TableColumn tableColumn = new TableColumn(0, jTableHeader.getWidth());
                tableColumn.setHeaderValue("Table");
                defaultTableColumnModel = new DefaultTableColumnModel();
                defaultTableColumnModel.addColumn(tableColumn);
            }
            jTableHeader.setColumnModel(defaultTableColumnModel);
        }

        @Override
        protected JTableHeader createInstanceImpl() {
            return new JTableHeader();
        }
    }

    private static class JTableBuilder
    extends ComponentBuilders.JComponentBuilder<JTable> {
        private final TableColumnModelBuilder columnModel;

        JTableBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.columnModel = TableColumnModelBuilder.fromField(instance, "columnModel", heap);
        }

        @Override
        protected JTable createInstanceImpl() {
            return new JTable();
        }

        @Override
        protected Component createPresenterImpl(JTable jTable) {
            DefaultTableColumnModel defaultTableColumnModel;
            DefaultTableColumnModel defaultTableColumnModel2 = defaultTableColumnModel = this.columnModel == null ? null : (DefaultTableColumnModel)this.columnModel.createInstance();
            if (defaultTableColumnModel == null || defaultTableColumnModel.getColumnCount() == 0) {
                TableColumn tableColumn = new TableColumn(0, jTable.getWidth());
                tableColumn.setHeaderValue("Table");
                defaultTableColumnModel = new DefaultTableColumnModel();
                defaultTableColumnModel.addColumn(tableColumn);
            }
            jTable.setColumnModel(defaultTableColumnModel);
            jTable.setPreferredScrollableViewportSize(jTable.getSize());
            return new JScrollPane(jTable);
        }
    }

    private static class TableColumnModelBuilder
    extends Utils.InstanceBuilder<DefaultTableColumnModel> {
        private final List<TableColumnBuilder> tableColumns = new ArrayList<TableColumnBuilder>();
        private final int columnMargin;

        TableColumnModelBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            int n;
            Instance instance2;
            Object object;
            this.columnMargin = DetailsUtils.getIntFieldValue(instance, "columnMargin", 1);
            Object object2 = instance.getValueOfField("tableColumns");
            if (object2 instanceof Instance && (object = (instance2 = (Instance)object2).getValueOfField("elementData")) instanceof ObjectArrayInstance && (n = DetailsUtils.getIntFieldValue(instance2, "elementCount", 0)) > 0) {
                ObjectArrayInstance objectArrayInstance = (ObjectArrayInstance)object;
                for (Object e : objectArrayInstance.getValues()) {
                    if (!(e instanceof Instance)) continue;
                    this.tableColumns.add(new TableColumnBuilder((Instance)e, heap));
                }
            }
        }

        static TableColumnModelBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)object, DefaultTableColumnModel.class.getName())) {
                return null;
            }
            return new TableColumnModelBuilder((Instance)object, heap);
        }

        @Override
        protected void setupInstance(DefaultTableColumnModel defaultTableColumnModel) {
            super.setupInstance(defaultTableColumnModel);
            for (TableColumnBuilder tableColumnBuilder : this.tableColumns) {
                defaultTableColumnModel.addColumn((TableColumn)tableColumnBuilder.createInstance());
            }
            defaultTableColumnModel.setColumnMargin(this.columnMargin);
        }

        @Override
        protected DefaultTableColumnModel createInstanceImpl() {
            return new DefaultTableColumnModel();
        }
    }

    private static class TableColumnBuilder
    extends Utils.InstanceBuilder<TableColumn> {
        private final int modelIndex;
        private final int width;
        private final String headerValue;

        TableColumnBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.modelIndex = DetailsUtils.getIntFieldValue(instance, "modelIndex", 0);
            this.width = DetailsUtils.getIntFieldValue(instance, "width", 75);
            String string = Utils.getFieldString(instance, "headerValue");
            this.headerValue = string != null ? string : "Col " + (this.modelIndex + 1);
        }

        @Override
        protected void setupInstance(TableColumn tableColumn) {
            super.setupInstance(tableColumn);
            tableColumn.setHeaderValue(this.headerValue);
        }

        @Override
        protected TableColumn createInstanceImpl() {
            return new TableColumn(this.modelIndex, this.width, null, null);
        }
    }

    private static class JTreeBuilder
    extends ComponentBuilders.JComponentBuilder<JTree> {
        private final boolean editable;

        JTreeBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.editable = DetailsUtils.getBooleanFieldValue(instance, "editable", false);
        }

        @Override
        protected void setupInstance(JTree jTree) {
            super.setupInstance(jTree);
            jTree.setEditable(this.editable);
        }

        @Override
        protected JTree createInstanceImpl() {
            return new JTree(new Object[0]);
        }
    }

    private static class JListBuilder
    extends ComponentBuilders.JComponentBuilder<JList> {
        private final DefaultListModelBuilder dataModel;

        JListBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.dataModel = DefaultListModelBuilder.fromField(instance, "dataModel", heap);
        }

        @Override
        protected void setupInstance(JList jList) {
            DefaultListModel defaultListModel;
            super.setupInstance(jList);
            DefaultListModel defaultListModel2 = defaultListModel = this.dataModel == null ? null : (DefaultListModel)this.dataModel.createInstance();
            if (defaultListModel != null) {
                jList.setModel(defaultListModel);
            }
        }

        @Override
        protected JList createInstanceImpl() {
            return new JList();
        }
    }

    private static class DefaultListModelBuilder
    extends Utils.InstanceBuilder<DefaultListModel> {
        private final List<String> model = new ArrayList<String>();

        DefaultListModelBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            int n;
            Instance instance2;
            Object object;
            Object object2 = instance.getValueOfField("delegate");
            if (object2 instanceof Instance && (object = (instance2 = (Instance)object2).getValueOfField("elementData")) instanceof ObjectArrayInstance && (n = DetailsUtils.getIntFieldValue(instance2, "elementCount", 0)) > 0) {
                ObjectArrayInstance objectArrayInstance = (ObjectArrayInstance)object;
                for (Object e : objectArrayInstance.getValues()) {
                    if (!(e instanceof Instance)) continue;
                    Instance instance3 = (Instance)e;
                    String string = DetailsUtils.getInstanceString(instance3, heap);
                    if (string == null) {
                        string = BrowserUtils.getSimpleType(instance3.getJavaClass().getName()) + " #" + instance3.getInstanceNumber();
                    }
                    this.model.add(string);
                }
            }
        }

        static DefaultListModelBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)object, DefaultListModel.class.getName())) {
                return null;
            }
            return new DefaultListModelBuilder((Instance)object, heap);
        }

        @Override
        protected void setupInstance(DefaultListModel defaultListModel) {
            super.setupInstance(defaultListModel);
            for (String string : this.model) {
                defaultListModel.addElement(string);
            }
        }

        @Override
        protected DefaultListModel createInstanceImpl() {
            return new DefaultListModel();
        }
    }

    private static class JComboBoxBuilder
    extends ComponentBuilders.JComponentBuilder<JComboBox> {
        private final boolean isEditable;
        private final String selectedObject;

        JComboBoxBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            Instance instance2;
            Object object;
            Instance instance3;
            this.isEditable = DetailsUtils.getBooleanFieldValue(instance, "isEditable", false);
            String string = null;
            Object object2 = instance.getValueOfField("dataModel");
            if (object2 instanceof Instance && DetailsUtils.isSubclassOf(instance3 = (Instance)object2, DefaultComboBoxModel.class.getName()) && (object = instance3.getValueOfField("selectedObject")) instanceof Instance && (string = DetailsUtils.getInstanceString(instance2 = (Instance)object, heap)) == null) {
                string = BrowserUtils.getSimpleType(instance2.getJavaClass().getName()) + " #" + instance2.getInstanceNumber();
            }
            this.selectedObject = string;
        }

        @Override
        protected void setupInstance(JComboBox jComboBox) {
            super.setupInstance(jComboBox);
            jComboBox.setEditable(this.isEditable);
            if (this.selectedObject != null) {
                jComboBox.addItem(this.selectedObject);
            }
        }

        @Override
        protected JComboBox createInstanceImpl() {
            return new JComboBox();
        }
    }
}

